/* pqueuepmain.c  -- Driver to test the pqueue       */

#include  <stdio.h>
#include  <stdlib.h>
#include  <unistd.h>
#include  <sys/types.h>
#include  <pthread.h>
#include  "qelem.h"
#include  "pqueuep.h"

   void producer(void * a);
   void consumer(void * a);

   int main(void)
   {
     pthread_t t1, t2;
     void *  pb;

     pb = pqueueinit(10);
     if (pthread_create(&t1, NULL, (void *)producer, pb)!=0) {
       perror("pthread_create");
       exit(1);
     }
     if (pthread_create(&t2, NULL, (void *)consumer, pb)!=0) {
       perror("pthread_create");
       exit(1);
     }
  
     /* Wait a while then exit: threads will die */
     sleep(60);
     printf("WE ARE DONE\n");
     return 0;
   }

   void producer(void * a) {
     while (1){
       pput(a, 'I');
       printf("I am thread producer\n");
       sleep(1);}
   }

   void consumer(void * a) {
     while (1){
       printf("I am thread consumer with %c\n", pget(a));
       sleep(3);}
   }
